# Essential Stuff

## Colors

``` css
--smokey-black: hsl(0, 0%, 7%);
--eerie-black: hsl(0, 0%, 9%);
--radical-red: hsl(346, 100%, 58%);
--white_a9: hsla(0, 0%, 100%, 0.09);
--white_a15: hsla(0, 0%, 100%, 0.15);
--white_a25: hsla(0, 0%, 100%, 0.25);
--white_a50: hsla(0, 0%, 100%, 0.5);
--white_a70: hsla(0, 0%, 100%, 0.7);
--white_a75: hsla(0, 0%, 100%, 0.75);
--white_a80: hsla(0, 0%, 100%, 0.8);
--jet-1: hsl(0, 0%, 20%);
--jet-2: hsl(0, 0%, 16%);
--white: hsl(0, 0%, 100%);
--black: hsl(0, 0%, 0%);
```

## Gradient color

``` css
--gradient-1: linear-gradient(180deg, transparent, var(--smokey-black));
--gradient-2: linear-gradient(180deg,var(--smokey-black) 25%,hsla(0, 0%, 0%, 0.6) 80%);
```

## Typography

``` css
--ff-recoleta: "Recoleta", serif;
--ff-gordita: "Gordita", sans-serif;

--fs-1: 6rem;
--fs-2: 5rem;
--fs-3: 3.8rem;
--fs-4: 2.8rem;
--fs-5: 2.6rem;
--fs-6: 2.2rem;
--fs-7: 2rem;
--fs-8: 1.8rem;
--fs-9: 1.5rem;
--fs-10: 1.4rem;
--fs-11: 1.2rem;

--fw-300: 300;
--fw-400: 400;
--fw-500: 500;
```

## Spacing

``` css
--section-padding: 60px;
```

## Shadow

``` css
--shadow: 0 12px 30px -10px hsla(0, 0%, 14%, 0.1);
```

## Border Radius

``` css
--radius-circle: 50%;
--radius-5: 5px;
--radius-25: 25px;
```

## Transition

``` css
--transition-1: 0.25s ease;
--transition-2: 0.5s ease;
--transition-3: 1s ease;
--cubic-in: cubic-bezier(0.51, 0.03, 0.64, 0.28);
--cubic-out: cubic-bezier(0.33, 0.85, 0.4, 0.96);
```
